<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('sell_transactions', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('sale_id')->nullable();
            $table->unsignedBigInteger('product_id');
            $table->string('payment_method')->nullable();
            $table->string('type')->nullable();
            $table->string('name')->nullable();
            $table->decimal('sell_price', 10, 2);
            $table->integer('sold_quantity');
            $table->decimal('profit', 10, 2);
            $table->string('warranty');
            $table->timestamp('date_time')->useCurrent();
            $table->foreign('product_id')->references('id')->on('products')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('sell_transactions');
    }
};
